/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.log;

import java.io.PrintStream;
import net.ftb.log.ILogListener;
import net.ftb.log.LogEntry;
import net.ftb.log.LogLevel;
import net.ftb.log.LogSource;
import net.ftb.log.LogType;

public class StdOutLogger
implements ILogListener {
    private static final PrintStream realStderr = System.err;
    private static final PrintStream realStdout = System.out;
    private LogType logType = LogType.EXTENDED;
    private LogSource logSource = LogSource.LAUNCHER;
    private LogLevel logLevel = LogLevel.UNKNOWN;

    public StdOutLogger() {
    }

    public StdOutLogger(LogSource logSource) {
        this.logSource = logSource;
    }

    @Override
    public void onLogEvent(LogEntry entry) {
        if (entry.source != this.logSource) {
            return;
        }
        if (entry.level == LogLevel.ERROR) {
            realStderr.println(entry.toString(this.logType));
        } else {
            realStdout.println(entry.toString(this.logType));
        }
    }

    public void setLogSource(LogSource logSource) {
        this.logSource = logSource;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }
}

